﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Services;
using VeteransAffairs.Registries.Business;  
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;    

/// <summary>
/// Summary description for VAMCInformation
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
[System.Web.Script.Services.ScriptService]
public class VAMCInformation : System.Web.Services.WebService
{

    public VAMCInformation()
    {

        //Uncomment the following line if using designed components 
        //InitializeComponent(); 
    }

    [WebMethod]
    public vamcAddress GetVAMCInformation(int vamcId)
    {
        InstitutionManager manager = new InstitutionManager();

        STD_INSTITUTION vamc = manager.GetInstitutionByInstitutionID(vamcId);

        vamcAddress vamcAddress = new vamcAddress();

        CityStateManager addressManager = new CityStateManager();

        if (vamc != null)
        {
            vamcAddress.Address1 = string.IsNullOrEmpty(vamc.MAILINGADDRESSLINE1) ?
                string.IsNullOrEmpty(vamc.STREETADDRESSLINE1) ? 
                        string.Empty : vamc.STREETADDRESSLINE1 
                : vamc.MAILINGADDRESSLINE1;
            vamcAddress.Address2 = string.IsNullOrEmpty(vamc.MAILINGADDRESSLINE1) ?
                string.IsNullOrEmpty(vamc.STREETADDRESSLINE2) ?
                        string.Empty : vamc.STREETADDRESSLINE2
                : string.IsNullOrEmpty(vamc.MAILINGADDRESSLINE2) ?
                        string.Empty : vamc.MAILINGADDRESSLINE2;
            vamcAddress.Address3 = string.IsNullOrEmpty(vamc.MAILINGADDRESSLINE1) ?
                string.IsNullOrEmpty(vamc.STREETADDRESSLINE3) ?
                        string.Empty : vamc.STREETADDRESSLINE3
                : string.IsNullOrEmpty(vamc.MAILINGADDRESSLINE3) ?
                        string.Empty : vamc.MAILINGADDRESSLINE3;
            vamcAddress.City = string.IsNullOrEmpty(vamc.MAILINGADDRESSLINE1) ?
                string.IsNullOrEmpty(vamc.STREETCITY) ?
                        string.Empty : vamc.STREETCITY
                : string.IsNullOrEmpty(vamc.MAILINGCITY) ?
                        string.Empty : vamc.MAILINGCITY;
            vamcAddress.EntireZip = string.IsNullOrEmpty(vamc.MAILINGADDRESSLINE1) ?
                   string.IsNullOrEmpty(vamc.STREETPOSTALCODE) ?
                        string.Empty : vamc.STREETPOSTALCODE
                : string.IsNullOrEmpty(vamc.MAILINGPOSTALCODE) ?
                        string.Empty : vamc.MAILINGPOSTALCODE;
 
            if (!String.IsNullOrEmpty(vamcAddress.EntireZip))
            {
                vamcAddress.Zip = vamcAddress.EntireZip;
                vamcAddress.Plus4 = string.Empty;
                if (vamcAddress.EntireZip.IndexOf('-') > -1)
                {
                    vamcAddress.Zip = vamcAddress.EntireZip.Split('-')[0];
                    vamcAddress.Plus4 = vamcAddress.EntireZip.Split('-')[1];
                }
            }

            int stateId = 0;
            if (string.IsNullOrEmpty(vamc.MAILINGADDRESSLINE1))
            {
                stateId = vamc.STREETSTATE_ID.HasValue ?
                    (int)vamc.STREETSTATE_ID : 0;
            }
            else
            {
                stateId = vamc.MAILINGSTATE_ID.HasValue ?
                    (int)vamc.MAILINGSTATE_ID : 0;
            }

            if (stateId > 0)
            {
                vamcAddress.State = addressManager.GetStateByID(stateId);
            }

            if (string.IsNullOrEmpty(vamcAddress.State))
            {
                vamcAddress.State = string.Empty;
            }

            int countryId = 0;
            if (string.IsNullOrEmpty(vamc.MAILINGADDRESSLINE1))
            {
                countryId = vamc.STREETCOUNTRY_ID.HasValue ?
                    (int)vamc.STREETCOUNTRY_ID : 0;
            }
            else
            {
                countryId = vamc.MAILINGCOUNTRY_ID.HasValue ?
                    (int)vamc.MAILINGCOUNTRY_ID : 0;
            }

            if (countryId > 0)
            {
                vamcAddress.Country = addressManager.GetCountryByID(countryId);
            }

            if (string.IsNullOrEmpty(vamcAddress.Country))
            {
                vamcAddress.Country = string.Empty;
            }

        }
        return vamcAddress;
    }

    
    public class vamcAddress
    {
        public string Address1 { get; set; }
        public string Address2 { get; set; }
        public string Address3 { get; set; }
        public string City { get; set; }
        public string State { get; set; }
        public string EntireZip { get; set; }
        public string Zip { get; set; }
        public string Plus4 { get; set; }
        public string Country { get; set; }

    }
   
        
}


    


